Name:           nodes
Version:        1.8.1
Release:        1%{?dist}
Summary:        Handle hierarchical groups of nodes
Vendor:         NSC

Group:          Development/Languages
License:        GPLv2+
URL:            http://www.nsc.liu.se/~kent/nodes/
Source0:        http://www.nsc.liu.se/~kent/nodes/%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python3-devel
Requires:       python3-hostlist


# The default value is '-s' (a subset of -I).
%global py3_shbang_opts -I


%description
Handle hierarchical groups of nodes, such as enclosures and racks.

%prep
%setup -q


%build
%py3_build


%install
%py3_install -- --prefix /usr


%files
%defattr(-,root,root,-)
%{python3_sitelib}/nodes.py
%{python3_sitelib}/nodes-*.egg-info
%{python3_sitelib}/__pycache__/*
/usr/bin/nodes
%config(noreplace) /etc/nodes.conf
/usr/share/man/man1/nodes.1.gz
/usr/share/man/man5/nodes.conf.5.gz
%doc nodes.conf.sample

%changelog
* Tue Nov 15 2022 Torbjörn Lönnemark <ketl@nsc.liu.se> - 1.8.1-1
- Let RPM handle Python interpreter line flags

* Thu Oct 27 2022 Torbjörn Lönnemark <ketl@nsc.liu.se> - 1.8.0-1
- Port to Python 3

* Wed Jun  2 2021 Torbjörn Lönnemark <ketl@nsc.liu.se> - 1.7-1
- Specify Python version explicitly in shebang
- Explicitly use Python 2 in Makefile
- Fix spec file for el8
- Remove unneeded python_sitelib fallback
- Update dependency hostlist to use new package name
- Include dist tag in Release in RPMs
- Add --convert-to-clustershell option.

* Fri Nov  2 2012 Kent Engström <kent@nsc.liu.se> - 1.6-1
- Add --count, --index and --index-separator.

* Mon Aug 23 2010 Kent Engström <kent@nsc.liu.se> - 1.5-1
- Add --expand together with --separator, --prepend and --append.

* Tue Mar  9 2010 Kent Engström <kent@nsc.liu.se> - 1.4-1
- Add --representative operation.
- Add --missing option for the --up operation.

* Sun Feb 21 2010 Kent Engström <kent@nsc.liu.se> - 1.3-1
- Add man pages nodes(1) and nodes.conf(5).
- Change gather behaviour when nodes do not belong to a group.
- Refactor and rename internal methods.
- Add unit tests.

* Tue Feb 09 2010 Kent Engström <kent@nsc.liu.se> - 1.2-1
- Add dynamic SLURM groups for users and jobs.

* Mon Nov 02 2009 Kent Engström <kent@nsc.liu.se> - 1.1-1
- Add one-letter options for --up, --fill and --gather.
- Add --config-file option.
- Allow abbreviations of level names as long as they are not ambiguous.

* Fri Oct 09 2009 Kent Engström <kent@nsc.liu.se> - 1.0-1
- Package as RPM.


